/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.minecraft.scoreboard;

import java.util.ArrayList;
import java.util.List;
import net.impactdev.impactor.api.scoreboards.Scoreboard;
import net.impactdev.impactor.api.scoreboards.ScoreboardRenderer;
import net.impactdev.impactor.api.scoreboards.lines.ScoreboardLine;
import net.impactdev.impactor.api.scoreboards.objectives.Objective;

public final class ImpactorScoreboard
implements Scoreboard {
    private final ScoreboardRenderer implementation;
    private final Objective objective;
    private final List<ScoreboardLine> lines;

    private ImpactorScoreboard(ImpactorScoreboardBuilder builder) {
        this.implementation = builder.implementation;
        this.objective = builder.objective;
        this.lines = builder.lines;
    }

    @Override
    public ScoreboardRenderer renderer() {
        return this.implementation;
    }

    @Override
    public Objective objective() {
        return this.objective;
    }

    @Override
    public List<ScoreboardLine> lines() {
        return this.lines;
    }

    public static class ImpactorScoreboardBuilder
    implements Scoreboard.ScoreboardBuilder {
        private ScoreboardRenderer implementation;
        private Objective objective;
        private final List<ScoreboardLine> lines = new ArrayList<ScoreboardLine>();

        @Override
        public Scoreboard.ScoreboardBuilder renderer(ScoreboardRenderer implementation) {
            this.implementation = implementation;
            return this;
        }

        @Override
        public Scoreboard.ScoreboardBuilder objective(Objective objective) {
            this.objective = objective;
            return this;
        }

        @Override
        public Scoreboard.ScoreboardBuilder line(ScoreboardLine line) {
            this.lines.add(line);
            return this;
        }

        @Override
        public Scoreboard build() {
            return new ImpactorScoreboard(this);
        }
    }
}

